<?php
class ControllerExtensionPaymentgoldP extends Controller
{
    public function index()
	{
        $this->load->language('extension/payment/goldp');

        $data1['text_connect'] = $this->language->get('text_connect');
        $data1['text_loading'] = $this->language->get('text_loading');
        $data1['text_wait'] = $this->language->get('text_wait');

        $data1['button_confirm'] = $this->language->get('button_confirm');

        return $this->load->view('extension/payment/goldp', $data1);
    }

    public function confirm()
	{
        $this->load->language('extension/payment/goldp');

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $amount = $this->correctAmount($order_info);

        $data1['return'] = $this->url->link('checkout/success', '', true);
        $data1['cancel_return'] = $this->url->link('checkout/payment', '', true);
        $data1['back'] = $this->url->link('checkout/payment', '', true);

        $MerchantID = $this->config->get('payment_goldp_pin');  	//Required
        $Amount = $amount; 									//Amount will be based on Toman  - Required
        $Description = $this->language->get('text_order_no') . $order_info['order_id']; // Required
        $Email = isset($order_info['email']) ? $order_info['email'] : ''; 	// Optional
        $Mobile = isset($order_info['fax']) ? $order_info['fax'] : $order_info['telephone']; 	// Optional
        $data['order_id'] = $this->encryption->encrypt($this->config->get('config_encryption'), $this->session->data['order_id']);
        //$data1['order_id'] = $this->encrypt($this->session->data['order_id']);
        $CallbackURL = $this->url->link('extension/payment/goldp/callback', 'orderKey=' . openssl_encrypt($this->session->data['order_id'], "AES-128-ECB", strtoupper(md5("goldP"))), true);  // Required

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, 'https://goldp.ir/webservice/rest/PaymentRequest');
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
		curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$Amount}&InvoiceID={$this->session->data['order_id']}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$curl_exec = curl_exec($curl);
		curl_close($curl);

		$result = json_decode($curl_exec);

		if (isset($result->Status) && $result->Status == 100)
		{
            $data1['action'] = $result->PaymentUrl;
            $json['success'] = $data1['action'];
		} else {
			$json = $this->checkState($result->Status);
		}

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function callback()
	{
		$this->load->language('extension/payment/goldp');

		$this->document->setTitle($this->language->get('text_title'));

		$data1['heading_title'] = $this->language->get('text_title');
		$data1['results'] = "";

		$data1['breadcrumbs'] = array();
		$data1['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home', '', true)
		);
		$data1['breadcrumbs'][] = array(
			'text' => $this->language->get('text_title'),
			'href' => $this->url->link('extension/payment/goldp/callback', '', true)
		);

		try {
			if($this->request->post['PaymentStatus'] != 'OK')
				throw new Exception($this->language->get('error_verify'));


			if (openssl_decrypt($this->request->get['orderKey'], "AES-128-ECB", strtoupper(md5("goldP"))) > 0)
			{
				$order_id = openssl_decrypt($this->request->get['orderKey'], "AES-128-ECB", strtoupper(md5("goldP")));
			} else {
				$order_id = 0;
			}

			$this->load->model('checkout/order');
			$order_info = $this->model_checkout_order->getOrder($order_id);

			if (!$order_info)
				throw new Exception($this->language->get('error_order_id'));

			$authority = $this->request->post['Authority'];
			$amount = $this->correctAmount($order_info);

			$verifyResult = $this->verifyPayment($authority, $amount);

			if (!$verifyResult)
				throw new Exception($this->language->get('error_connect_verify'));

			switch ( array_keys($verifyResult)[0] ) {
				case 'RefID': // success
					$comment = $this->language->get('text_results') . $verifyResult['RefID'];
					$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('payment_goldp_order_status_id'), $comment, true);

					$data1['error_warning'] = NULL;
					$data1['results'] = $verifyResult['RefID'];
					$data1['button_continue'] = $this->language->get('button_complete');
					$data1['continue'] = $this->url->link('checkout/success');
					break;

				case 'Status': // error with error status
					throw new Exception($this->checkState($verifyResult['Status'])['error']);
					break;
			}

		} catch (Exception $e) {
			$data1['error_warning'] = $e->getMessage();
			$data1['button_continue'] = $this->language->get('button_view_cart');
			$data1['continue'] = $this->url->link('checkout/cart');
		}

		$data1['column_left'] = $this->load->controller('common/column_left');
		$data1['column_right'] = $this->load->controller('common/column_right');
		$data1['content_top'] = $this->load->controller('common/content_top');
		$data1['content_bottom'] = $this->load->controller('common/content_bottom');
		$data1['footer'] = $this->load->controller('common/footer');
		$data1['header'] = $this->load->controller('common/header');

		$this->response->setOutput($this->load->view('extension/payment/goldp_confirm', $data1));
    }

    private function correctAmount($order_info) {
        $amount = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
        $amount = round($amount);
        $amount = $this->currency->convert($amount, $order_info['currency_code'], "TOM");
        return (int)$amount;
    }

    private function checkState($status) {
        $json = array();
        $json['error'] = "Error {$status}";

        return $json;
    }

    private function verifyPayment($authority, $amount)
	{
        $MerchantID = $this->config->get('payment_goldp_pin');

		if ($this->request->post['PaymentStatus'] == 'OK')
		{
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://goldp.ir/webservice/rest/PaymentVerification');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$amount}&Authority={$authority}");
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result = json_decode($curl_exec);

			if (isset($result->Status) && $result->Status == 100)
			{
				return ['RefID' => $result->RefID];
			} else {
				return ['Status' => $result->Status];
			}
		} else {
			return false;
		}
    }
}
?>