<?
/*
  Virtual Freer
  http://freer.ir/virtual

  Copyright (c) 2011 Mohammad Hossein Beyram, freer.ir

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v3 (http://www.gnu.org/licenses/gpl-3.0.html)
  as published by the Free Software Foundation.
*/
//-- اطلاعات کلی پلاگین
$pluginData[goldp][type] 					= 'payment';
$pluginData[goldp][name] 					= 'گلد پی(gold P)';
$pluginData[goldp][uniq] 					= 'goldp';
$pluginData[goldp][description] 				= 'مخصوص پرداخت با دروازه پرداخت <a href="https://goldp.ir">گلد پی(gold P)</a>';
$pluginData[goldp][author][name] 			= 'Milad Maldar';
$pluginData[goldp][author][url] 				= 'http://miladworkshop.ir';
$pluginData[goldp][author][email] 			= 'hossin@gmail.com';

//-- فیلدهای تنظیمات پلاگین
$pluginData[goldp][field][config][1][title] 	= 'مرچنت';
$pluginData[goldp][field][config][1][name] 	= 'merchant';
$pluginData[goldp][field][config][2][title] 	= 'عنوان خرید';
$pluginData[goldp][field][config][2][name] 	= 'title';

//-- تابع انتقال به دروازه پرداخت
function gateway__goldp($data)
{
	global $config,$db,$smarty;

	$merchantID 	= trim($data[merchant]);
	$amount 		= round($data[amount]/10);
	$invoice_id		= $data[invoice_id];
	$callBackUrl 	= $data[callback];
	$Description 	= $data[title].' - '.$data[invoice_id];
	$Email 			= "";
	$Mobile 		= "";

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, 'https://goldp.ir/webservice/rest/PaymentRequest');
	curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
	curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$merchantID}&Amount={$amount}&InvoiceID={$invoice_id}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($callBackUrl));
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	$curl_exec = curl_exec($curl);
	curl_close($curl);

	$result = json_decode($curl_exec);

	if (isset($result->Status) && $result->Status == 100)
	{
		header("Location: {$result->PaymentUrl}");
		
		$update[payment_rand] 	= $result->Authority;
		$sql 					= $db->queryUpdate('payment', $update, 'WHERE `payment_rand` = "'.$invoice_id.'" LIMIT 1;');
		$db->execute($sql);

		@header("location: {$result->PaymentUrl}");
		exit;
		
	} else {
		$errStatus 		= (isset($result->Status) && $result->Status != "") ? $result->Status : "Error connecting to web service";
		$data[title] 	= 'خطای سیستم';
		$data[message] 	= '<font color="red">در اتصال به درگاه گلد پی(gold P) مشکلی به وجود آمد٬ لطفا از درگاه سایر بانک‌ها استفاده نمایید.</font>'.$errStatus.'<br /><a href="index.php" class="button">بازگشت</a>';
		$query			= 'SELECT * FROM `config` WHERE `config_id` = "1" LIMIT 1';
		$conf			= $db->fetch($query);
		$smarty->assign('config', $conf);
		$smarty->assign('data', $data);
		$smarty->display('message.tpl');
	}
}

//-- تابع بررسی وضعیت پرداخت
function callback__goldp($data)
{
	global $db, $get;

	if (isset($_POST['PaymentStatus']) && $_POST['PaymentStatus'] == 'OK')
	{
		$Authority 	= (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";
		$InvoiceID 	= (isset($_POST['InvoiceID']) && $_POST['InvoiceID'] != "") ? $_POST['InvoiceID'] : "";
		
		$merchantID = $data[merchant];
		$sql 		= 'SELECT * FROM `payment` WHERE `payment_rand` = "'.$Authority.'" LIMIT 1;';
		$payment 	= $db->fetch($sql);
		$amount		= round($payment[payment_amount]/10);

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, 'https://goldp.ir/webservice/rest/PaymentVerification');
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
		curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$merchantID}&Amount={$amount}&Authority={$Authority}");
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$curl_exec = curl_exec($curl);
		curl_close($curl);

		$result = json_decode($curl_exec);

		if ($payment[payment_status] == 1)
		{
			if (isset($result->Status) && $result->Status == 100)
			{
				//-- آماده کردن خروجی
				$output[status]		= 1;
				$output[res_num]	= $Authority;
				$output[ref_num]	= $result->RefID;
				$output[payment_id]	= $payment[payment_id];
			} else {
				$errStatus 		= (isset($result->Status) && $result->Status != "") ? $result->Status : "Error connecting to web service";
				//-- در تایید پرداخت مشکلی به‌وجود آمده است‌
				$output[status]	= 0;
				$output[message]= 'پرداخت توسط گلد پی(gold P) تایید نشد‌ : '.$errStatus;
			}
		} else {
			//-- قبلا پرداخت شده است‌
			$output[status]	= 0;
			$output[message]= 'سفارش قبلا پرداخت شده است.';
		}
	} else {
		//-- شماره یکتا اشتباه است
		$output[status]	= 0;
		$output[message]= 'تراکنش لغو شد';
	}

	return $output;
}